#!/bin/bash

# ! check the path of the model_id
# ! check the dataset name
# ! check the train_size
# ! check the seed

accelerate launch  --main_process_port 29501 \
        new_sft.py \
        --seed 42 \
        --gradient_checkpointing \
        --fp16 \
        --ckpts_dir /mnt/sharedata/ssd/users/zhanghx/save_data/book \
        --dataset BookTection \
        --model_id /mnt/sharedata/ssd/users/zhanghx/models/llama-7b \
        --batch_size 8 \
        --num_workers 8 \
        --learning_rate 1e-3 \
        --prompt general \
        --num_train_epochs 3 \
        --train_size 0.3 \
        --split train \
        --num_warmup_steps 10 \
        --tuner lora \

# /mnt/sharedata/ssd/common/LLMs/hub/opt-6.7b
# /mnt/sharedata/ssd/users/zhanghx/models/gpt-neox\-20b


## 定义包含不同 train_size 比例的数组
# train_sizes=(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9)

# for train_size in "${train_sizes[@]}"; do
#     echo "Running training with train_size=${train_size}"
    
#     # 调用训练脚本，并传递当前的 train_size 比例
#     accelerate launch new_sft.py \
#         --seed 42  \
#         --gradient_checkpointing \
#         --fp16 \
#         --ckpts_dir /mnt/sharedata/ssd/users/zhanghx/save_data/checkpoint/rate \
#         --dataset WikiMIA \
#         --model_id /mnt/sharedata/ssd/users/zhanghx/models/llama-7b \
#         --batch_size 8 \
#         --num_workers 8 \
#         --learning_rate 1e-3 \
#         --prompt general \
#         --num_train_epochs 3 \
#         --train_size ${train_size} \
#         --split train \
#         --num_warmup_steps 10
# done